local super = require "Object"

Formatter = super:new()

function Formatter:evaluate(sequence)
    local formatter = self:getFormatter()
    if formatter then
        local arguments = self:getArguments()
        return sequence:map(function(number)
            return formatter:format(number, unpack(arguments))
        end)
    else
        return Sequence:newWithArray({})
    end
end

function Formatter:getFormatter()
    return nil
end

function Formatter:getArguments()
    return {}
end

function Formatter:getInspectorInfo()
    return {}
end

function Formatter:getInspectors()
    local list = List:new()
    local inspectorInfo = self:getInspectorInfo()
    for i = 1, #inspectorInfo do
        local info = inspectorInfo[i]
        list:add(self:createInspector(unpack(info)))
    end
    return list
end

function Formatter:getInterval()
    return nil
end

return Formatter
